/*
 * Test OpenMP support by compiling and running this file.
 * Use your favourite C compiler
 *
 * Compile:
 *
 *   gcc:
 *     gcc -fopenmp preparation.c -o preparation.c.exe
 *     - gcc name might also be gcc-<ver>, e.g. gcc-11, gcc-12
 *
 *   clang:
 *     clang -fopenmp preparation.c -o preparation.c.exe
 *     - compiler name might also be clang-<ver>, e.g. clang-12, clang-13,
 *       clang-14
 *
 *   Intel compiler:
 *     - classic compiler icc:
 *       icc -qopenmp preparation.c -o preparation.c.exe
 *     - or next gen compiler icx:
 *       icx -qopenmp preparation.c -o preparation.c.exe
 *
 *   MS VC++ compiler:
 *     cl /openmp /Fe: preparation.c.exe preparation.c
 *
 * Run:
 *
 *   ./preparation.c.exe
 *
 *   should print something like:
 *
 *       OpenMP support: 201511
 *
 *       thread 0 of <y>
 *       thread 1 of <y>
 *       ...
 *
 */
#include <stdio.h>

#include <omp.h>

int main(int argc, char * argv[])
{
    printf("OpenMP support: %d\n\n", _OPENMP);
    #pragma omp parallel
    {
        printf("thread %d of %d\n",
               omp_get_thread_num(),
               omp_get_num_threads());
    }

    return 0;
}
