!
! Test OpenMP support by compiling and running this file.
! Use your favourite Fortran compiler
!
! Compile:
!
!   gfortran:
!     gfortran -fopenmp preparation.F90 -o preparation.F90.exe
!     - gcc name might also be gfortran-<ver>, e.g.
!       gfortran-11, gfotran-12
!
!   flang:
!     flang -fopenmp preparation.c -o preparation.c.exe
!     - flang name might also be flang-<ver>, e.g. flang-12,
!       flang-13, flang-14
!
!   Intel compiler:
!     - classic compiler ifort:
!       ifort -qopenmp preparation.c -o preparation.c.exe
!     - or next gen compiler ifx:
!       ifx -qopenmp preparation.c -o preparation.c.exe
!
! Run:
!
!   ./preparation.F90.exe
!
!   should print something like:
!
!       OpenMP support: 201511
!
!       thread            0  of            <n>
!       thread            1  of            <n>
!       ...
!

program preparation

  use omp_lib

  implicit none

  write (*,*) 'OpenMP support: ', _OPENMP

  !$omp parallel
    write(*,*) 'thread ', omp_get_thread_num(), ' of ', omp_get_num_threads()
  !$omp end parallel


end program
