# Parallel Pi computation

The quarter circle in the ﬁrst quadrant with origin at (0,0) and radius 1 has
an area of Pi/4.  Look at the random number pairs in [0, 1] x [0, 1]. The
probability that such a point lies inside the quarter circle is Pi/4, so given
enough statistics we are able to calculate Pi using this "Monte Carlo" method.


## Compile

You can find a serial version (C and Fortran90) in the pi-monte-carlo
directory.

In order to compile an OpenMP program, you have to use

* `-fopenmp` for gcc/clang/gfortran/flang-new
* `-qopenmp` for icc/ifort/icx/ifx

In this example for gcc/clang you also have to link explicitly against the
math library with `-lm`.

When compiled, the program prints its runtime and the relative accuracy of the
computed approximation to Pi.


## Task: Parallelize

Parallelize the code using OpenMP.

* ensure the relevant variables are made `shared` or `(first)private`
* use the corresponding synchronization directives for coordinating updates to
  shared variables or use the `reduction` clause

Note the use of the `rand_r()` function to get separate random number sequences
for all threads.

What is the best relative accuracy that you can achieve with all cores?


## OpenMP runtime functions you might need

* make runtime functions available:
  * C/C++: use `#include <omp.h>`
  * Fortran: use `use omp_lib`

Functions:

* `omp_get_thread_num()`: returns the thread id of a thread, in the range of 0 to no. of threads - 1
* `omp_get_max_threads()`: returns no. of threads used in the next parallel region
* `omp_get_wtime()`: returns no. of seconds since some point in time
