! gfortran -Wall pi-monte-carlo.F90 -o pi-monte-carlo.F90.exe
! ifort -Wall pi-monte-carlo.F90 -o pi-monte-carlo.F90.exe
! icx -Wall pi-monte-carlo.F90 -o pi-monte-carlo.F90.exe
module timing
  public get_time
contains

  double precision function get_time()
    implicit none
    integer :: c, rate, m

    call system_clock(c, rate, m)
    get_time = dble(c) / dble(rate)
  end function
end module


program mcpi
  use, intrinsic :: iso_c_binding
  use timing

  implicit none

  interface
    integer(c_int) function rand_r(seed) bind(c)
      import :: c_int
      integer(c_int), intent(in) :: seed
    end function rand_r
  end interface

  integer(c_int) :: seed
  integer(c_int), parameter :: RAND_MAX = 2147483647
  double precision :: x, y
  double precision :: t_start
  double precision :: pi
  double precision :: duration
  double precision, parameter :: M_PI = 3.14159265358979323846d0
  integer :: i, count
  integer, parameter :: NN=342000000

  count = 0
  seed = 2

  t_start = get_time()

  do i = 1, NN
    x = rand_r(seed) / DBLE(RAND_MAX)
    y = rand_r(seed) / DBLE(RAND_MAX)
    if (sqrt(x * x + y * y) < 1.d0) count = count + 1
  enddo

  pi = 4.d0 * DBLE(count) / NN

  duration = get_time() - t_start

  write(*,*) 'perf: ', dble(NN) / duration / 1e6,    &
             ' Mit/sec, duration: ', duration,       &
             ' s, accuracy: ', abs(M_PI - pi) / M_PI

end program mcpi
