# Affinity

Set environment variable `OMP_DISPLAY_AFFINITY=true` do get information about
on which place each OpenMP thread is allowed to run.

* Linux
  * bash: `export OMP_DISPLAY_AFFINITY=true`
  * csh: `setenv OMP_DISPLAY_AFFINITY true`
* Windows / cmd: `set OMP_DISPLAY_AFFINTIY=true`


## Affinity Format

Environment variable `OMP_AFFINITY_FORMAT` controls what information is
printed, when `OMP_DISPLAY_AFFINITY` is enabled.


It works like the format syntax for `printf`, but with own fields:

* `%n` / `%{thread_num}`: thread id
* `%N` / `%{num_threads}`: no. of threads in current parallel region
* `%H` / `%{host}`: host name
* `%P` / `%{process_id}`: process id
* `%i` / `%{native_thread_id}`: native thread id
* `%A` / `%{thread_affinity}`: calling thread's affinity

For more specifiers see the OpenMP standard.

Fields can be adjusted in width and padding, e.g. `%0.7n`:

* `0` causes leading zeros to be print
* `.` causes right aligned output,
* `7` sets the field size

Example:

```bash
export OMP_AFFINITY_FORMAT="OpenMP thread id %.3n affinity %A"
```


## Compile

In order to compile an OpenMP program, you have to use

* gcc, clang, gfortran, flang-new: `-fopenmp affinity.c -o affinity`
* icc, ifort, icx, ifx: `-qopenmp affinity.c -o affinity`
* nvc, nvfortran: `-mp affinity.c -o affinity`

Example:

```bash
gcc -fopenmp affinity.c -o affinity
```


## Tasks

### Examine topology

Tools and files, where to get topology from:

* `/proc/cpuinfo`
* `lscpu`
* `lstopo` (hwloc)
* `likwid-topology`
* `numactl` (`numactl -H`)
* `nvidia-smi` (`nvidia-smi topo -m`), for GPUs

Determine how many sockets, cores, HW threads, HW threads/core are on your system?

### Set thread affinity

Compile the affinity application and run it with different affinity settings.

Use for exmaple 2 threads (control via `OMP_NUM_THREADS`) and bind them to:

* separate HW threads (if available, i.e. HW threads/core > 1)
* separate cores
  * ensure the two thread are close to each other
  * ensure the two thread are far away from each other
* separate socket (if available)

What happens if there are more threads than places available?
