/**
 * @brief Evaluate polynomial of @p degreep with @coefficients at @x.
 * @param x             Value of x.
 * @param degree        Degeree of the polynomial.
 * @param coefficients  Pointer to coefficents array.  The array holds @p degreee + 1
 *                      coefficients in reverse order, i.e. a_0 = coefficents[degree],
 *                      a_1 = coefficients[degree - 1], ... a_degree = coefficients[0].
 * @return Evaluated polynomial at @p x.
 */
double
poly_eval(double x, int degree, const double * coefficients)
{
    double f = coefficients[0];
    for (int i = 1; i <= degree; ++i) {
        f = x * f + coefficients[i];
    }
    return f;
}
