module mod_poly_eval
  public poly_eval

  integer, parameter :: dp = kind(1.d0)

contains
  real(kind=dp) function poly_eval(x, degree, coefficients)

    implicit none
    integer, intent(in) :: degree
    real(kind=dp), intent(in) :: x
    real(kind=dp), intent(in) :: coefficients(0:degree)

    integer :: i
    poly_eval = coefficients(0)
    do i = 1, degree
      poly_eval = x * poly_eval + coefficients(i)
    end do

  end function
end module
