module mod_poly_eval
  public poly_eval

  integer, parameter :: dp = kind(1.d0)

contains
  real(kind=dp) function poly_eval(x, degree, coefficients)
    !$omp declare simd simdlen(2)  uniform(degree, coefficients) notinbranch
    !$omp declare simd simdlen(4)  uniform(degree, coefficients) notinbranch
    !$omp declare simd simdlen(8)  uniform(degree, coefficients) notinbranch
    !$omp declare simd simdlen(16) uniform(degree, coefficients) notinbranch

    implicit none
    integer, intent(in) :: degree
    real(kind=dp), intent(in) :: x
    real(kind=dp), intent(in) :: coefficients(0:degree)

    integer :: i
    poly_eval = coefficients(0)
    do i = 1, degree
      poly_eval = x * poly_eval + coefficients(i)
    end do

  end function
end module
